unit UCCDWebBrowser;

interface

uses
  Classes, ActnList, SHDocVw,
  UCCDBaseComp, UCCDTypes;

type
  TCCDWebBrowser = class(TWebBrowser)
  private
    FLinks: TStrings;
    FAboutCCD: TAboutCCD;
    FActionList: TCustomActionList;
    FOnBeforeNavigate2: TWebBrowserBeforeNavigate2;
  private
    procedure InitNewDocument();
    function GetEnlaces(): TStrings;
    procedure SetActionList(Value: TCustomActionList);
    procedure CheckLinks(Sender: TObject; const pDisp: IDispatch;
      var URL: OleVariant; var Flags: OleVariant; var TargetFrameName: OleVariant;
        var PostData: OleVariant; var Headers: OleVariant; var Cancel: WordBool);
  protected
    procedure Notification(component: TComponent; operation: TOperation); override;
  public
    destructor Destroy; override;
    procedure WriteHtml(html: string);
    constructor Create(AOwner: TComponent); override;
    function LinkPerAction(const action: TAction): string;
  published
    property Links: TStrings read GetEnlaces;
    property AboutCCD: TAboutCCD read FAboutCCD stored false;
    property ActionList: TCustomActionList read FActionList write SetActionList;
    property OnBeforeNavigate2: TWebBrowserBeforeNavigate2 read FOnBeforeNavigate2 write FOnBeforeNavigate2;
  end;

implementation

uses
  MSHTML, Variants, ActiveX, SysUtils, UCCDResources;

{ TCCDWebBrowser }

constructor TCCDWebBrowser.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FLinks := TStringList.Create();
  inherited OnBeforeNavigate2 := CheckLinks;
end;

destructor TCCDWebBrowser.Destroy();
begin
  FLinks.Free();
  inherited Destroy;
end;

procedure TCCDWebBrowser.Notification(Component: TComponent;
  Operation: TOperation);
begin
  inherited Notification(Component, Operation);
  if (Operation = opRemove) and (Component = FActionList) then
    FActionList := nil
end;

function TCCDWebBrowser.GetEnlaces(): TStrings;
var
  i: integer;
begin
  if Assigned(FActionList) then
  begin
    FLinks.Clear();
    for i := 0 to FActionList.ActionCount-1 do
    begin
      with FActionList do begin
        FLinks.Add(Format(rsCCDActionLink,
          [FActionList[i].Name, TAction(FActionList[i]).Caption,
            TAction(FActionList[i]).Caption]));
      end;
    end;
  end;
  result := FLinks;
end;

procedure TCCDWebBrowser.SetActionList(value: TCustomActionList);
begin
  if (FActionList <> value) then
  begin
    FActionList := value;
    if Assigned(value) then
      value.FreeNotification(Self)
  end
end;

procedure TCCDWebBrowser.InitNewDocument();
begin
  Navigate(rsCCDUrlAboutBlank);
end;

procedure TCCDWebBrowser.CheckLinks(sender: TObject;
  const pDisp: IDispatch; var URL, Flags, TargetFrameName,
  PostData, Headers: OleVariant; var Cancel: WordBool);
var
  i: integer;
  enlace: string;
begin
  Cancel := false;
  if Assigned(FActionList) then begin
    for i := 0 to FActionList.ActionCount-1 do
    begin
      enlace := Format(rsCCDPosibleLink,
        [FActionList.Actions[i].Name]);
      if (Pos(enlace, URL) <> 0) then
      begin
        Cancel := true;
        FActionList.Actions[i].Execute;
      end;
    end;
  end;
  if Assigned(FOnBeforeNavigate2) then begin
    FOnBeforeNavigate2(Sender, pDisp, URL, Flags,
      TargetFrameName, PostData, Headers, Cancel);
  end;
end;

function TCCDWebBrowser.LinkPerAction(
 const action: TAction): string;
begin
  Result := Format(rsCCDActionLink,[action.Name,
             action.Caption,action.Caption]);
end;

procedure TCCDWebBrowser.WriteHtml(html: string);
var
  temp: Variant;
  doc: IHTMLDocument2;
begin
  InitNewDocument();
  temp := VarArrayCreate([0,0],varVariant);
  temp[0] := html;
  doc := (self.Document as IHTMLDocument2);
  doc.Write(PSafeArray(TVarData(temp).VArray));
  doc.Close();
  doc := nil;
  self.Refresh();
end;

end.
