{
TCCDSelectOnRunTime  Component Version 1.3 - Suite GLib
Copyright () 2005,  by Germn Estvez (Neftal)

  Permite seleccionar componentes visuales que haya en un form de forma visual
  como se hace con las imgenes en los programas de diseo o con los controles
  en el IDE de Delphi. Adems se pueden mover y redimensionar los controles
  seleccionados
  Basta con soltar el control en el formulario, asignarle el control que se desea
  seleccionar/mover/redimensionar y activarlo.
  Se pueden distinguir qu controles se seleccionan utilizando la propiedad
  SelectTag/SelectTaggedControls. 
  
=========================================================================
IMPORTANTE PROGRAMADORES: Por favor, si tienes comentarios, mejoras, ampliaciones,
  errores y/o cualquier otro tipo de sugerencia envame un mail a: 
  german_ral@hotmail.com
  
IMPORTANT PROGRAMMERS: please, if you have comments, improvements, enlargements,
errors and/or any another type of suggestion send a mail to: 
german_ral@hotmail.com    
=========================================================================

@author Germn Estvez (Neftal)
@cat Package GLib
}
unit UCCDSelectOnRunTime;
{
=========================================================================

  CSelectOnRunTime.pas

  Componente

========================================================================
  Historia de las Versiones
------------------------------------------------------------------------

  10/09/2006
	* Corregidos problemas al mover componentes que estn colocados dentro
		de otros.
	* Corregido bug al pintar las marcas de seleccin cuando un control est
		dentro de otro.
	* Bugs varios.
  24/03/2006
    * Aadidas propiedades nuevas para definir qu controles se seleccionan o no.
    * SelectTaggedControls y SelectTag (thks. Jose)
    * Corregido buq en la propiedad Selected cuando se asignaba por cdigo.
    * En diseo las marcas no deben ser visibles.
  17/03/2006
    * Aadido parmetro CanMoveOutParent a los eventos de movimmiento para
      restringir el movimiento de un contro fuera de su padre.
  02/11/2005
    * Revisin de los mtodos de seleccin.
    * Ideas: Delphi About
    * Propiedad de color.
  03/10/2005
    * Implementado el movimiento de los controles y de las marcas de seleccin.
  30/09/2005
    * Creacin.

=========================================================================

  Errores detectados no corregidos

=========================================================================
}

//=========================================================================
//
// I N T E R F A C E
//
//=========================================================================
interface

uses
  Controls, Windows, Messages, SysUtils, Classes, ExtCtrls, Graphics, Contnrs,
  UCCDBaseComp;

type

  //: Ampliacin de la clase.
  TExtControl = class(TControl);

  {: Tipo definido para el evento OnBeforeSelect.}
  TBeforeSelectEvent = procedure(Sender: TObject; Selected:TControl;
                                 var Select:Boolean) of object;
  {: Tipo definido para el evento CanMove. }
  TCanMoveEvent = procedure (Sender: TObject; Control:TControl;
                             var CanMove: Boolean;
                             var CanMoveOutParent:Boolean) of object;

  {: Tipo definido para el evento de redimensionar}
  TCanResizeControlEvent = procedure(Sender: TObject; var CanResize: Boolean) of object;

  {: Clase para definir el componente de seleccion.}
  TCCDSelectOnRunTime = class(TCCDBaseComp)
  private
    _InReposition: boolean;       // Se est recolocando un control
    _NodePositioning: Boolean;    // Si se est recolocando una marca
    _OldPos: TPoint;              // posicion anterior
    _Nodes: TObjectList;          // Lista de marcas
    _CurrentNodeControl: TControl;   // Control actual
    _Owner: TComponent;                 // El formulario que contiene el control
    _OldMouseDown, _OldMouseUp:TMouseEvent;
    _OldMouseMove:TMouseMoveEvent;
    _OldResize: TNotifyEvent;
    _CapturedEvents:Boolean;            // Si estn capturados ya los eventos del control

    FSelected:Boolean;
    FSelectControl:TControl;
    FActive:Boolean;
    FMarkColor: TColor;
    FMarkers3D: Boolean;
    FOnBeforeSelect: TBeforeSelectEvent;
    FOnCanMove: TCanMoveEvent;
    FOnCanResize: TCanResizeControlEvent;
    FSelectTaggedControls: Boolean;
    FSelectTag: Integer;

    // Eventos al seleccionar un control.
    procedure ControlMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ControlMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure ControlMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure ControlResize (Sender: TObject);
    // procedimientos para los eventos al seleccionar una marca
    procedure NodeMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure NodeMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure NodeMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

    // Capturar los eventos del control.
    procedure _CaptureEvents();
    // liberar los eventos del control (restaurarlos anteriores)
    procedure _FreeEvents();

    procedure SetActive(const Value: Boolean);
    procedure SetSelectControl(Value: TControl);
    //: Colocar las marcas de seleccion segun el control.
    procedure PositionNodes(AroundControl: TControl; AVisible:Boolean=True);
    //: Visualizar/Ocultar las marcas.
    procedure NodesVisible(Visible: Boolean);
    //: Crea los nodos que visalizan la seleccin.
    procedure CreateNodes;

    procedure SetMarkColor(const Value: TColor);
    procedure SetMarkers3D(const Value: Boolean);
    procedure SetSelected(const Value: Boolean);

  protected


  public
    // Redefnimos el constructor.
    constructor Create(AOwner: TComponent); override;
    // Redefnimos el destructor.
    destructor Destroy; override;
    //: Define si hay algo seleccionado o no.
    property Selected:Boolean read FSelected write SetSelected;

  published
    //: Control que vamos a seleccionar
    property SelectControl:TControl read FSelectControl write SetSelectControl;
    //: Activar el componente
    property Active:Boolean read FActive write SetActive;
    //: Propiedades del pintado de las markas
    // property MarkColor:TColor read FMarkColor write SetMarkColor;
    //: Si las marcas las queremos en 3D
    property Markers3D: Boolean read FMarkers3D write SetMarkers3D;
    //: Activa que slo se seleccionen los controles con un determinado TAG
    property SelectTaggedControls:Boolean read FSelectTaggedControls
        write FSelectTaggedControls default False;
    // TAG para los controles a seleccionar (depende de la prop. SelectTaggedControls)
    property SelectTag:Integer read FSelectTag write FSelectTag default 999; 

    // EVENTOS
    // =========================================================================
    property OnBeforeSelect: TBeforeSelectEvent read FOnBeforeSelect write FOnBeforeSelect;
    property OnCanMove: TCanMoveEvent read FOnCanMove write FOnCanMove;
    property OnCanResize:TCanResizeControlEvent read FOnCanResize write FOnCanResize;

  end;

//=========================================================================
//
// I M P L E M E N T A T I O N
//
//=========================================================================
implementation

uses
  Forms, Dialogs;

{ TCCDSelectOnRunTime }
{============================================================================}


//: Construictor de la clase
procedure TCCDSelectOnRunTime.ControlMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  _CanSelect:Boolean;
begin

  if (Self.FActive) AND (Sender is TControl) then begin

    _CanSelect := True;
    // Asignado el evento antes de asignar?
    if Assigned(Self.FOnBeforeSelect) then begin
      Self.FOnBeforeSelect(Self, TControl(Sender), _CanSelect);
    end;

    // No se debe seleccionar o estamos en modo TagControl y no coincide
    if (not _CanSelect) or
       (Self.FSelectTaggedControls) and (TControl(Sender).Tag <> FSelectTag) then begin
      Exit;
    end;

    Self._InReposition:=True;
    Self.FSelected := True;

    // Es un TWinControl?
    if (Sender is TWinControl) then begin
      SetCapture(TWinControl(Sender).Handle);
      Self.FSelectControl := TWinControl(Sender);
    end;
    GetCursorPos(_OldPos);
    // Colocar las marcas segun el control
    PositionNodes(TControl(Sender));
  end;
end;

procedure TCCDSelectOnRunTime.ControlMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
const
  minWidth = 20;
  minHeight = 20;
var
  newPos: TPoint;
  frmPoint : TPoint;
  _CanMove, _CanMoveOutParent:Boolean;
  newLeft, newTop, newRight, newBottom:Integer;
  parentRight, parentBootom:Integer;
begin
  // Se est reposicionando?
  if (Self._InReposition) then begin

    _CanMove := True;
    _CanMoveOutParent := False;

    // Est asignado el evento
    if Assigned(Self.FOnCanMove) then begin
      Self.FOnCanMove(Self, TControl(Sender), _CanMove, _CanMoveOutParent);
    end;
    // No se puede redimensionar?
    if not(_CanMove) then begin
      Exit;
    end;

    // El control es correcto?
    with TControl(Sender) do begin
      // posicion
      GetCursorPos(newPos);
      // Modificar el cuursor
      Screen.Cursor := crSize;

      // Nueva posicion
      newLeft := Left - _OldPos.X + newPos.X;
      newTop := Top - _OldPos.Y + newPos.Y;
      newRight := newLeft + Width;
      newBottom := newTop + Height;

      if Assigned(TControl(Sender).Parent) then begin
        parentRight := TControl(Sender).Parent.Width;
        parentBootom := TControl(Sender).Parent.Height;
      end;

      // Est fuera de lmites y no se puede (Left)
      if ((newLeft < 0) and (_CanMoveOutParent)) or (newLeft >= 0) then begin
        // Posicion
        Left := newLeft;
      end;

      // Est fuera de lmites y no se puede (Right)
      if ((newRight > parentRight) and (_CanMoveOutParent)) or (newRight <= parentRight) then begin
        // Posicion
        Left := newLeft;
      end;

      // Est fuera de lmites y no se puede (Bottom)
      if ((newBottom > parentBootom) and (_CanMoveOutParent)) or (newBottom <= parentBootom) then begin
        Top := newTop;
      end;

      // Est fuera de lmites y no se puede (Top)
      if ((newTop < 0) and (_CanMoveOutParent)) or (newTop >= 0) then begin
        Top := newTop;
      end;

      _OldPos := newPos;
    end;
    // Reporsicionar las marcas
    PositionNodes(TControl(Sender));
  end;

  // Seleccionado?  ==> Cambiar el Cursor
  if FSelected then begin
    TControl(Sender).Cursor := crSize;
  end;

end;

procedure TCCDSelectOnRunTime.ControlMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // Recolocando?
  if (Self._InReposition) then begin
    // Dejar el cursor como estaba
    Screen.Cursor := crDefault;
    // Liberar
    ReleaseCapture;
    // Dejar de recolocar
    Self._InReposition := False;
  end;

end;


procedure TCCDSelectOnRunTime.ControlResize(Sender: TObject);
begin
  // Reporsicionar las marcas
  PositionNodes(TControl(Sender));
end;

constructor TCCDSelectOnRunTime.Create(AOwner: TComponent);
begin

  // Mtodo heredado
  inherited;
  // Owner del control
  Self._Owner := AOwner;

  // otras propiedades por defecto
  Self.FMarkColor := clBlack;
  Self.FMarkers3D := False;
  Self._CapturedEvents := False;
  Self.FSelectTag := 9999;

  // Lista de nodos
  _Nodes := TObjectList.Create(False);
  // Crearlos
  CreateNodes;
end;

//: destructor de la clase;
procedure TCCDSelectOnRunTime.CreateNodes();
var
  Node: Integer;
  Panel: TPanel;
begin
  // Para las 8 Marcas.
  for Node := 0 to 7 do  begin
    // Crear un panel
    Panel := TPanel.Create(Self);
    // Aadirlo
    _Nodes.Add(Panel);
    // Para cada uno
    with Panel do  begin

      // No marcas en 3D?
      if not (Self.FMarkers3D) then begin
        BevelOuter := bvNone;
      end;
      // Otras
      Color := FMarkColor;
      Brush.Color := FMarkColor;
      Name := 'Node' + IntToStr(Node);
      Width := 5;
      Height := 5;
      Parent := TWinControl(Self._Owner);
      Visible := False;

      // Segun el nodo
      case Node of
        0,4: Cursor := crSizeNWSE;
        1,5: Cursor := crSizeNS;
        2,6: Cursor := crSizeNESW;
        3,7: Cursor := crSizeWE;
      end;
      // Asignar eventos
      OnMouseDown := NodeMouseDown;
      OnMouseMove := NodeMouseMove;
      OnMouseUp := NodeMouseUp;
    end;
  end;

end;

//: Destructor de la clase
destructor TCCDSelectOnRunTime.Destroy;
begin

  // Liberar objetos creados
  _Nodes.Free;
  // mtopdo heredado
  inherited;

end;

//: Mtodo de acceso apare escritura a la prop. active.
procedure TCCDSelectOnRunTime.NodeMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // Est activo y el Sender es correcto
  if (Self.FActive) AND (Sender is TControl) then begin
    // Reposicionando nodo
    Self._NodePositioning:=True;
    // Es un TWinControl?
    if (Sender is TWinControl) then begin
      // Capturar el control
      SetCapture(TWinControl(Sender).Handle);
    end;
    // Gusrdar la posicion
    GetCursorPos(_OldPos);
  end;
end;

procedure TCCDSelectOnRunTime.NodeMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
const
  minWidth = 20;
  minHeight = 20;
var
  newPos: TPoint;
  frmPoint : TPoint;
  OldRect: TRect;
  AdjL,AdjR,AdjT,AdjB: Boolean;
  _CanResize:Boolean;
begin
  // Se est reposicionando un nodo?
  if Self._NodePositioning then begin

    _CanResize := True;
    // Est asignado el evento
    if Assigned(Self.FOnCanResize) then begin
      Self.FOnCanResize(Sender, _CanResize);
    end;
    // No se puede redimensionar?
    if not(_CanResize) then begin
      Exit;
    end;

    Application.ProcessMessages;
    begin
      with TControl(Sender) do
      begin
      GetCursorPos(newPos);
      with Self._CurrentNodeControl do  begin
        //resize
        frmPoint := Self._CurrentNodeControl.Parent.ScreenToClient(Mouse.CursorPos);
        OldRect := Self._CurrentNodeControl.BoundsRect;
        AdjL := False;
        AdjR := False;
        AdjT := False;
        AdjB := False;
        case Self._Nodes.IndexOf(TControl(Sender)) of
          0: begin
               AdjL := True;
               AdjT := True;
             end;
          1: begin
               AdjT := True;
             end;
          2: begin
               AdjR := True;
               AdjT := True;
             end;
          3: begin
               AdjR := True;
             end;
          4: begin
               AdjR := True;
               AdjB := True;
             end;
          5: begin
               AdjB := True;
             end;
          6: begin
               AdjL := True;
               AdjB := True;
             end;
          7: begin
               AdjL := True;
             end;
        end;

        if AdjL then
          OldRect.Left := frmPoint.X;
        if AdjR then
          OldRect.Right := frmPoint.X;
        if AdjT then
          OldRect.Top := frmPoint.Y;
        if AdjB then
          OldRect.Bottom := frmPoint.Y;
        SetBounds(OldRect.Left,OldRect.Top,OldRect.Right - OldRect.Left,OldRect.Bottom - OldRect.Top);
      end;
      Left := Left - _OldPos.X + newPos.X;
      Top := Top - _OldPos.Y + newPos.Y;
      _OldPos := newPos;
      end;
    end;
    PositionNodes(Self._CurrentNodeControl);
  end;

end;

procedure TCCDSelectOnRunTime.NodeMouseUp(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  // Recolocando nodo?
  if (Self._NodePositioning) then begin
    // Cursor estandard
    Screen.Cursor := crDefault;
    // Liberar captura
    ReleaseCapture;
    // poner a false
    Self._NodePositioning := False;
  end;
end;

//: Colocar las marcas de seleccion segun el control.
procedure TCCDSelectOnRunTime.PositionNodes(AroundControl: TControl; AVisible:Boolean=True);
var
  Node,T,L,CT,CL,FR,FB,FT,FL: Integer;
  TopLeft: TPoint;
begin
  // Inicializar
  Self._CurrentNodeControl := nil;
  // Para cada nodo
  for Node := 0 to 7 do  begin
    // Con el control seleccionado
    with AroundControl do
    begin
      CL := (Width div 2) + Left -2;
      CT := (Height div 2) + Top -2;
      FR := Left + Width - 2;
      FB := Top + Height - 2;
      FT := Top - 2;
      FL := Left - 2;
      case Node of
        0: begin
             T := FT;
             L := FL;
           end;
        1: begin
             T := FT;
             L := CL;
           end;
        2: begin
             T := FT;
             L := FR;
           end;
        3: begin
             T := CT;
             L := FR;
           end;
        4: begin
             T := FB;
             L := FR;
           end;
        5: begin
             T := FB;
             L := CL;
           end;
        6: begin
             T := FB;
             L := FL;
           end;
        7: begin
             T := CT;
             L := FL;
           end;
        else
          T := 0;
          L := 0;
      end;
      TopLeft := Parent.ClientToScreen(Point(L,T));
    end;
    // Para cada marca
    with TPanel(Self._Nodes[Node]) do
    begin
      TopLeft := Parent.ScreenToClient(TopLeft);
      Top := TopLeft.Y;
      Left := TopLeft.X;
    end;
  end;
  // Control actual
  Self._CurrentNodeControl := AroundControl;

  // Visualizar?
  if (AVisible) then begin
    NodesVisible(True);
  end;

end;

//: Procedimiento de escritura a la propiedad.
procedure TCCDSelectOnRunTime.SetSelected(const Value: Boolean);
begin
  // Asignamos el valor
  Self.FSelected := Value and Assigned(Self.FSelectControl);

  // desactivar
  if not (Value) then begin
    // Asignado?
    if Assigned(Self.FSelectControl) then begin
      Self.FSelectControl.Cursor := crDefault;
    end;
    Self.SelectControl := nil;
    Exit;
  end
  else begin
    // Asignado?
    if Assigned(Self.FSelectControl) then begin
      PositionNodes(TControl(Self.FSelectControl));
    end;
  end;

  // Ocular nodos
  Self.NodesVisible(Self.FSelected);

end;

//: Procedimiento de escritura a la propiedad.
procedure TCCDSelectOnRunTime.SetActive(const Value: Boolean);
var
  i:Integer;
begin

  // No ha cambiado?
  if (Self.FActive = Value) then begin
    Exit;
  end;

  // Activar?
  if (Value) then begin
    // Se va a seleccionar uno?
    if Assigned(Self.FSelectControl) and not (_CapturedEvents) then begin
      Self._CaptureEvents();
    end;
  end
  else begin
    // Se va a seleccionar uno?
    if Assigned(Self.FSelectControl) and (_CapturedEvents) then begin
      Self._FreeEvents();
    end;
  end;

  // Activar/desactivar
  Self.FActive := Value;
  // Deselecconar
  Self.Selected := False;

end;



//: Mtodo de escritura de la propiedad SelectControl.
procedure TCCDSelectOnRunTime.SetMarkColor(const Value: TColor);
var
  Node: Integer;
begin
  FMarkColor := Value;
  for Node := 0 to 7 do
    TPanel(Self._Nodes.Items[Node]).Color := Value;
end;

//: Visualizar/Ocultar las marcas.
procedure TCCDSelectOnRunTime.NodesVisible(Visible: Boolean);
var
  Node: Integer;
  wc:TWinControl;
  repos:Boolean;
begin

  // Visible?
  if (Visible) then begin
    // Hay que cambiar el PArent
    if Assigned(Self.SelectControl) then begin
      // Parent
      wc := Self.SelectControl.Parent;
      // Asignado?
      if Assigned(wc) then begin
        // Es Diferente?
        if (TControl(Self._Nodes.Items[0]).Parent <> wc) then begin
          repos := True;
        end;
      end;
    end;
  end;

  // Para cada marca.
  for Node := 0 to 7 do begin
    // Visible y no en diseo
    TControl(Self._Nodes.Items[Node]).Visible :=
      Visible and (not (csDesigning in Self.ComponentState));
    if (repos) then begin
      TControl(Self._Nodes.Items[Node]).Parent := wc;
    end;
  end;

  // reposicionar?
  if (repos) then begin
    PositionNodes(Self.SelectControl, False);
  end;

end;

procedure TCCDSelectOnRunTime.SetSelectControl(Value: TControl);
var
  _CanSelect:Boolean;
begin

  // Es un form, frame o el Owner
  if (Value is TForm) or (Value is TFrame) or (Value = Self.Owner) then begin
    Self.SelectControl := nil;
    Exit;
  end;

  // No ha cambiado?
  if (Self.FSelectControl = Value) then begin
    Exit;
  end;

  // En diseo?
  if (csDesigning in Self.ComponentState) then begin
    // Asignar
    Self.FSelectControl := Value;
    NodesVisible(False);
    Exit;
  end;

  // Se pasa a nil
  if not Assigned(Value) then begin
    Self.FSelectControl.Cursor := crDefault;
    // Estn capturados los eventos y activo
    if (_CapturedEvents) and (Self.FActive) then begin
      Self._FreeEvents();
    end;
  end
  else begin
    _CanSelect := True;
    // Asignado el evento antes de asignar?
    if Assigned(Self.FOnBeforeSelect) then begin
      Self.FOnBeforeSelect(Self, Value, _CanSelect);
    end;

    // No se debe seleccionar o estamos en modo TagControl y no coincide
    if (not _CanSelect) or
       (Self.FSelectTaggedControls) and (Value.Tag <> FSelectTag) then begin
      // Actualizar Selected
      Self.Selected := False;
      Exit;
    end;
  end;

  // Asignar
  Self.FSelectControl := Value;
  // Actualizar Selected
  Self.Selected := Assigned(Value);

  // Se va a seleccionar uno?
  if Assigned(Value) and (Self.FActive) then begin
    Self._CaptureEvents();
  end;
end;

// "desenganchar" los eventos del control
procedure TCCDSelectOnRunTime._FreeEvents();
begin
  _CapturedEvents := False;
  // Restaurar los eventos
  TExtControl(Self.FSelectControl).OnMouseDown := _OldMouseDown;
  TExtControl(Self.FSelectControl).OnMouseMove := _OldMouseMove;
  TExtControl(Self.FSelectControl).OnMouseUp := _OldMouseUp;
end;

// "senganchar" los eventos del control
procedure TCCDSelectOnRunTime._CaptureEvents();
begin
  _CapturedEvents := True;
  // Guardar las anteriores configuraciones
  _OldMouseDown := TExtControl(Self.FSelectControl).OnMouseDown;
  _OldMouseMove := TExtControl(Self.FSelectControl).OnMouseMove;
  _OldMouseUp := TExtControl(Self.FSelectControl).OnMouseUp;
  _OldResize := TExtControl(Self.FSelectControl).OnResize;

  // "Cach" del evento
  TExtControl(Self.FSelectControl).OnMouseDown := ControlMouseDown;
  TExtControl(Self.FSelectControl).OnMouseMove := ControlMouseMove;
  TExtControl(Self.FSelectControl).OnMouseUp := ControlMouseUp;
  TExtControl(Self.FSelectControl).OnResize := ControlResize;

end;



procedure TCCDSelectOnRunTime.SetMarkers3D(const Value: Boolean);
var
  Node: Integer;
begin
  FMarkers3D := Value;
  for Node := 0 to 7 do begin
    if (Value) then begin
      TPanel(Self._Nodes.Items[Node]).BevelOuter := bvRaised;
    end
    else begin
      TPanel(Self._Nodes.Items[Node]).BevelOuter := bvNone;
    end;
  end;
end;



end.
