unit UCCDRichEdit;

interface

uses
  Windows, ComCtrls, Classes, Controls, Messages,
  ShellApi, UCCDBaseComp, UCCDTypes;

type
  TUrlClick = procedure(sender: TObject; url: string; var open: boolean) of object;

type
  TCCDRichEdit = class(TRichEdit)
  private
    FOpenUrls: boolean;
    FAboutCCD: TAboutCCD;
    FOnUrlClick: TUrlClick;
  private
    procedure CNNotify(var Msg: TWMNotify); message CN_NOTIFY;
  protected
    procedure OpenUrl(url: string);
    procedure CreateWnd(); override;
  public
    constructor Create(aOwner: TComponent); override;
  published
    property AboutCCD: TAboutCCD read FAboutCCD stored false;
    property OnUrlClick: TUrlClick read FOnUrlClick write FOnUrlClick;
    property OpenUrls: boolean read FOpenUrls write FOpenUrls default true;
  end;

implementation

uses
  SysUtils, RichEdit;

{ TCCDRichEdit }

constructor TCCDRichEdit.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FOpenUrls := true;
end;

procedure TCCDRichEdit.OpenUrl(url: string);
begin
  if (Trim(url) <> EmptyStr) then begin
    ShellExecute(Handle,'open',PChar(url),nil,nil,SW_NORMAL);
  end;
end;

procedure TCCDRichEdit.CreateWnd();
begin
  inherited CreateWnd();
  SendMessage(Handle, EM_AUTOURLDETECT, 1, 0);
  SendMessage (Handle, EM_SETEVENTMASK, 0, ENM_LINK);
end;

procedure TCCDRichEdit.CNNotify(var Msg: TWMNotify);
type
  PENLink = ^TENLink;
var
  RT: TextRange;
begin
  case Msg.NMHdr^.code of
    EN_LINK: begin
      if (PENLink(Msg.NMHdr).Msg=WM_LBUTTONDOWN) then
      begin
        RT.chrg := PENLink(Msg.NMHdr).chrg;
        GetMem(RT.lpstrText, RT.chrg.cpMax - RT.chrg.cpMin + 2);
        try
          SendMessage(Handle, EM_GETTEXTRANGE, 0, Integer(@RT));
          if Assigned(FOnUrlClick) then
            FOnUrlClick(Self, RT.lpstrText, FOpenUrls);
          if FOpenUrls then
            OpenUrl(RT.lpstrText);
        finally
          FreeMem(RT.lpstrText);
        end;
      end;
      Msg.Result := 0;
    end;
  end;
end;

end.
 
