unit UCCDNoPastEdit;

interface

uses
  Classes, StdCtrls, Messages,
  UCCDBaseComp, UCCDTypes;

type
  TCCDNoPastEdit = class(TEdit)
  private
    FCanPaste: boolean;
    FAboutCCD: TAboutCCD;
  private
    procedure WMPaste(var Message: TMessage); message WM_PASTE;
    procedure WMRButtonDown(var Message: TMessage); message WM_RBUTTONDOWN;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property AboutCCD: TAboutCCD read FAboutCCD stored false;
    property CanPaste: boolean read FCanPaste write FCanPaste default false;
  end;

implementation

{ TCCDNoPastEdit }

constructor TCCDNoPastEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FCanPaste := false;
end;

procedure TCCDNoPastEdit.WMPaste(var Message: TMessage);
begin
  if not FCanPaste then
    Exit;
  inherited;
end;

procedure TCCDNoPastEdit.WMRButtonDown(var Message: TMessage);
begin
  if not FCanPaste and not
   Assigned(self.PopupMenu) then
    Exit;
  inherited;
end;

end.
