unit UCCDLabelSopr;

interface

uses
  Controls, Classes, Stdctrls, Windows,
  ExtCtrls, Graphics, Messages, UCCDTypes;

type
  TCCDLabelSopr =class(TCustomControl)
  private
    FCaption: string;
    FLabelUp: TLabel;
    FLabelDown: TLabel;
    FLabelRear: TLabel;
    FMainLabel: TLabel;
    FLabelFront: TLabel;
    FAboutCCD: TAboutCCD;
    FPrimaryTimer: TTimer;
    FPrimaryColor: TColor;
    FPrimaryFlash: boolean;
    FSecondaryColor: TColor;
    FSecondaryTimer: TTimer;
    FSecondaryFlash: boolean;
    FInterchangeColor: TColor;
    FPrimaryInterval: integer;
    FSecondaryInterval: integer;
  private
    procedure SetCaption(value: string);
    procedure LabelsClick(sender: TObject);
    procedure PrimaryTimer(sender:TObject);
    procedure SecondaryTimer(sender:TObject);
    procedure SetPrimaryColor(value: TColor);
    procedure SetPrimaryFlash(value: boolean);
    procedure SetSecondaryColor(value: TColor);
    procedure SetSecondaryFlash(value: boolean);
    procedure SetPrimaryInterval(value: integer);
    procedure SetSecondaryInterval(value: integer);
    procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
  public
    procedure CreateParams(var Params: TCreateParams);override;
    procedure Refresh;
    constructor Create(aOwner: TComponent); override;
    destructor Destroy(); override;
  published
    property Font;
    property OnClick;
    property AutoSize;
  published
    property Caption: string read FCaption write SetCaption;
    property AboutCCD: TAboutCCD read FAboutCCD stored false;
    property PrimaryFlash: boolean read FPrimaryFlash write SetPrimaryFlash default false;
    property PrimaryColor: TColor read FPrimaryColor write SetPrimaryColor default clWhite;
    property SecondaryColor: TColor read FSecondaryColor write SetSecondaryColor default clRed;
    property SecondaryFlash: boolean read FSecondaryFlash write SetSecondaryFlash default false;
    property PrimaryInterval: integer read FPrimaryInterval write SetPrimaryInterval default 100;
    property InterchangeColor: TColor read FInterchangeColor write FInterchangeColor default clLime;
    property SecondaryInterval: integer read FSecondaryInterval write SetSecondaryInterval default 200;
  end;

implementation

constructor TCCDLabelSopr.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FPrimaryFlash := false;
  FPrimaryInterval := 400;
  FPrimaryColor := clWhite;
  FCaption := 'ClubDelphi';
  FSecondaryFlash := false;
  FSecondaryColor := clRed;
  FSecondaryInterval := 2000;
  FInterchangeColor := clTeal;
  AutoSize:=True;
  FPrimaryTimer := TTimer.Create(self);
  with FPrimaryTimer do begin
    Enabled := false;
    OnTimer := PrimaryTimer;
    Interval := FPrimaryInterval;
  end;
  FSecondaryTimer := TTimer.Create(self);
  with FSecondaryTimer do begin
    Enabled := false;
    OnTimer := SecondaryTimer;
    Interval := FSecondaryInterval;
  end;

  FLabelUp := TLabel.Create(self);
  with FLabelUp do begin
    Parent := self;
    Top := self.Top;
    Caption := FCaption;
    Left := self.Left + 2;
    OnClick := LabelsClick;
    Font.Color := FSecondaryColor;
    Transparent:=True;
  end;
  FLabelDown := TLabel.Create(self);
  with FLabelDown do begin
    Parent := self;
    Top := self.Top + 4;
    Caption := FCaption;
    Left := self.Left + 2;
    OnClick := LabelsClick;
    Font.Color := FSecondaryColor;
    Transparent:=True;
  end;
  FLabelRear := TLabel.Create(self);
  with FLabelRear do begin
    Parent := self;
    Left := self.Left;
    Top := self.Top + 2;
    Caption := FCaption;
    OnClick := LabelsClick;
    Font.Color := FSecondaryColor;
    Transparent:=True;
  end;
  FLabelFront := TLabel.Create(self);
  with FLabelFront do begin
    Parent := self;
    Top := self.Top + 2;
    Caption := FCaption;
    Left := self.Left + 4;
    OnClick := LabelsClick;
    Font.Color := FSecondaryColor;
    Transparent:=True;
  end;

  FMainLabel := TLabel.Create(self);
  with FMainLabel do begin
    Parent := self;
    Top := self.Top + 2;
    Caption := FCaption;
    Left := self.Left + 2;
    OnClick := LabelsClick;
    Font.Color := FPrimaryColor;
    Transparent:=True;
  end;
  with self.Font do begin
    Size := 12;
    Name := 'Arial';
    Style := [fsbold];
  end;
end;

destructor TCCDLabelSopr.Destroy();
begin
  FLabelUp.Free();
  FLabelDown.Free();
  FLabelRear.Free();
  FMainLabel.Free();
  FLabelFront.free();
  FPrimaryTimer.Free();
  FSecondaryTimer.Free();
  inherited Destroy();
end;

procedure TCCDLabelSopr.SetPrimaryColor(value : TColor);
begin
  if (FPrimaryColor <> value) then
  begin
    FPrimaryColor := value;
    FMainLabel.Font.Color := value;
  end;
end;

procedure TCCDLabelSopr.SetSecondaryColor(value: TColor);
begin
  if (FSecondaryColor <> value) then
  begin
    FSecondaryColor := value;
    FLabelUp.Font.Color := value;
    FLabelDown.Font.Color := value;
    FLabelRear.Font.Color := value;
    FLabelFront.Font.Color := value;
  end;
end;

procedure TCCDLabelSopr.SetPrimaryInterval(value: integer);
begin
  if (FPrimaryInterval <> value) then
  begin
    FPrimaryInterval := value;
    FPrimaryTimer.Interval := value;
  end;
end;

procedure TCCDLabelSopr.SetSecondaryInterval(value: integer);
begin
  if (FSecondaryInterval <> value) then
  begin
    FSecondaryInterval := value;
    FSecondaryTimer.Interval := value;
  end;
end;

procedure TCCDLabelSopr.SetPrimaryFlash(value: boolean);
begin
  if (FPrimaryFlash <> value) then
  begin
    FPrimaryFlash := value;
    FPrimaryTimer.Enabled := value;
  end;
  FMainLabel.Visible := not FPrimaryFlash;
  Refresh;
end;

procedure TCCDLabelSopr.SetSecondaryFlash(value: boolean);
begin
  if (FSecondaryFlash <> value) then
  begin
    FSecondaryFlash := value;
    FSecondaryTimer.Enabled := value;
  end;
  if not FSecondaryFlash then begin
    FLabelUp.Font.Color := FSecondaryColor;
    FLabelDown.Font.Color := FSecondaryColor;
    FLabelRear.Font.Color := FSecondaryColor;
    FLabelFront.Font.Color := FSecondaryColor;
  end;
  Refresh;
end;

procedure TCCDLabelSopr.SetCaption(value: string);
begin
  if (FCaption <> value) then
  begin
    FCaption := value;
    FLabelUp.Caption := value;
    FLabelDown.Caption := value;
    FLabelRear.Caption := value;
    FMainLabel.Caption := value;
    FLabelFront.Caption := value;
  end;
end;

procedure TCCDLabelSopr.LabelsClick(sender: TObject);
begin
  self.Click();
end;

procedure TCCDLabelSopr.PrimaryTimer(sender:TObject);
begin
  if not (csDesigning in self.ComponentState) and FPrimaryFlash then
    FMainLabel.Visible := not FMainLabel.Visible;
    Refresh;
end;


procedure TCCDLabelSopr.SecondaryTimer(sender:TObject);
var
  i: integer;
begin
  if not (csDesigning in self.ComponentState) and FSecondaryFlash then
  begin
    for i := 0 to self.ComponentCount-2 do begin
      if (self.Components[i] is TLabel) then begin
        if TLabel(self.Components[i]).Font.Color = FSecondaryColor then
          TLabel(self.Components[i]).Font.Color := FInterchangeColor
        else
          TLabel(self.Components[i]).Font.Color := FSecondaryColor;
      end;
    end;
    Refresh;
  end;
end;

procedure Tccdlabelsopr.CMFontChanged(var Message: TMessage);
begin
  inherited;
  FLabelUp.Font := self.Font;
  FLabelRear.Font := self.Font;
  FMainLabel.Font := self.Font;
  FLabelDown.Font := self.Font;
  FLabelFront.Font := self.Font;
  FLabelUp.Font.Color := FSecondaryColor;
  FLabelDown.Font.Color := FSecondaryColor;
  FLabelRear.Font.Color := FSecondaryColor;
  FMainLabel.Font.Color := FPrimaryColor;
  FLabelFront.Font.Color := FSecondaryColor;
  Refresh;
end;

procedure Tccdlabelsopr.CreateParams(var Params: TCreateParams);
begin
   inherited CreateParams(Params);
   Params.ExStyle:= Params.ExStyle + WS_EX_Transparent;
   ControlStyle := ControlStyle-[csOpaque]+[csAcceptsControls];
end;

procedure Tccdlabelsopr.Refresh();
var
  Vartex: string;
begin
  Vartex := Caption;
  Caption := '';
  Caption := Vartex;
end;

end.
