unit UCCDLabelClock;

interface

uses
  Classes, StdCtrls, ExtCtrls,
  UCCDBaseComp, UCCDTypes;

type
  TCCDLabelClock = class(TLabel)
  private
    FAmPm: boolean;
    FClock: TTimer;
    FActive: boolean;
    FAboutCCD: TAboutCCD;
    procedure SetActive(value: boolean);
    procedure TimerClock(sender: TObject);
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy(); override;
  published
    property AboutCCD: TAboutCCD read FAboutCCD stored false;
    property AmPm: boolean read FAmPm write FAmPm default false;
    property Active: boolean read FActive write SetActive default false;
  end;

implementation

uses
  SysUtils, UCCDResources;

constructor TCCDLabelClock.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FAmPm := false;
  FActive := false;
  FClock := TTimer.Create(self);
  Caption := FormatDateTime(rsCCDHourFormat,Time);
  with FClock do begin
    Interval := 1000;
    Enabled := FActive;
    OnTimer := TimerClock;
  end;
end;

destructor TCCDLabelClock.Destroy();
begin
  FClock.Free;
  inherited Destroy();
end;

procedure TCCDLabelClock.SetActive(value: boolean);
begin
  if (FActive <> value) then
  begin
    FActive := value;
    FClock.Enabled := value;
  end;
end;

procedure TCCDLabelClock.TimerClock(sender: TObject);
begin
  if not FAmPm then
    Self.Caption := FormatDateTime(rsCCDHourFormat,Time)
  else
    Self.Caption := FormatDateTime(rsCCDAmPmHourFormat,Time);
end;

end.
