unit UCCDFooterButtons;

interface

uses
  Classes, Controls, StdCtrls,
  ExtCtrls, Messages, UCCDTypes;

type
  TCCDFooterButtons = class(TWinControl)
  private
    FPanel: TPanel;
    FOkButton: TButton;
    FOkCaption: string;
    FAboutCCD: TAboutCCD;
    FCancelButton: TButton;
    FCancelCaption: string;
    FOnOkClick: TNotifyEvent;
    FOnCancelClick: TNotifyEvent;
    procedure ButtonClick(sender: TObject);
    procedure SetOkCaption(value: string);
    procedure SetCancelCaption(value: string);
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy(); override;
  published
    property Color;
  published
    property AboutCCD: TAboutCCD read FAboutCCD stored false;
    property OkCaption: string read FOkCaption write SetOkCaption;
    property OnOkClick: TNotifyEvent read FOnOkClick write FOnOkClick;
    property CancelCaption: string read FCancelCaption write SetCancelCaption;
    property OnCancelClick: TNotifyEvent read FOnCancelClick write FOnCancelClick;
  end;

implementation

uses
  Consts, SysUtils, UCCDResources, UCCDExceptions;

{ TCCDFooterButtons }

procedure TCCDFooterButtons.ButtonClick(sender: TObject);
begin
  case (sender as TButton).ModalResult of
    mrOk: if Assigned(FOnOkClick) then
        FOnOkClick(sender);
    mrCancel: if Assigned(FOnCancelClick) then
        FOnCancelClick(sender);
  end;
end;

constructor TCCDFooterButtons.Create(aOwner: TComponent);
const
  BTN_TOP = 8;
  BTN_LEFT = 8;
  PNL_HEIGHT = 40;
  DBTN_LEFT = BTN_LEFT*2;
begin
  inherited Create(aOwner);
  Align := alBottom;
  FOkCaption := LoadResString(@SMsgDlgOK);
  FCancelCaption := LoadResString(@SMsgDlgCancel);
  FPanel := TPanel.Create(self);
  with FPanel do begin
    Parent := self;
    Align := alClient;
    Caption := EmptyStr;
    Height := PNL_HEIGHT;
  end;
  FOkButton := TButton.Create(self);
  with FOkButton do begin
    TabOrder := 0;
    Top := BTN_TOP;
    Default := true;
    Parent := FPanel;
    ModalResult := mrOk;
    Caption := FOkCaption;
    OnClick := ButtonClick;
    Anchors := [akRight,akBottom];
    Left := FPanel.Width-Width-BTN_LEFT;
  end;
  FCancelButton := TButton.Create(self);
  with FCancelButton do begin
    TabOrder := 1;
    Top := BTN_TOP;
    Cancel := true;
    Parent := FPanel;
    OnClick := ButtonClick;
    ModalResult := mrCancel;
    Caption := FCancelCaption;
    Anchors := [akRight,akBottom];
    Left := (FPanel.Width)-(Width*2)-DBTN_LEFT;
  end;
end;

destructor TCCDFooterButtons.Destroy();
begin
  FPanel.Free();
  inherited Destroy();
end;

procedure TCCDFooterButtons.SetOkCaption(value: string);
begin
  if (FOkCaption <> value) then begin
    FOkCaption := value;
    FOkButton.Caption := value;
  end;
end;

procedure TCCDFooterButtons.SetCancelCaption(value: string);
begin
  if (FCancelCaption <> value) then begin
    FCancelCaption := value;
    FCancelButton.Caption := value;
  end;
end;

end.
