unit UCCDEditZoom;

interface

uses
   Windows, ExtCtrls, SysUtils, Controls,
   Messages, Classes, StdCtrls, Graphics,
   UCCDTypes;

type
  TCCDEditZoom = class(TEdit)
  private
    { Private declarations }
    FAboutCCD: TAboutCCD;

    FZoom: Boolean;
    FVColor: TColor;
    FVWidth: integer;
    FMaxWidth: Integer;
    FEnterColor: Tcolor;
    FOnExit: TNotifyEvent;
    FOnEnter: TNotifyEvent;
  protected
  { Protected declarations }
    procedure CMMouseenter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseleave(var Message: TMessage); message CM_MOUSELEAVE;

  public
    { Public declarations }
    constructor Create(aOwner: TComponent); override;
    destructor Destroy(); override;
    procedure DoEnter; override;
    procedure DoExit; override;
    procedure SetZoom(value: boolean);
    procedure SetEnterColor(value: TColor);
    procedure SetMaxWidth(value: integer);
  published
    { Published declarations }
    property AboutCCD: TAboutCCD read FAboutCCD stored false;

    property OnEnter: TNotifyEvent read FOnEnter write FOnEnter;
    property OnExit: TNotifyEvent read FOnExit write FOnExit;
    property Zoom: boolean read FZoom write SetZoom default True;
    property EnterColor: TColor read FEnterColor write SetEnterColor default claqua;
    property MaxWidth: integer read FMaxWidth write SetMaxWidth default 0;
  end;

implementation

constructor TCCDEditZoom.Create(aOwner: TComponent);
begin
    inherited Create(aOwner);
    FEnterColor:= ClAqua;
    FZoom:= True;
    FVColor:= Color;
    FVWidth:=Width;
    FMaxWidth:=0;
end;

destructor TCCDEditZoom.Destroy();
begin
  inherited Destroy();
end;

procedure TCCDEditZoom.SetEnterColor(value : TColor);
begin
  if (FEnterColor <> value) then FEnterColor:= value;
end;

procedure TCCDEditZoom.SetZoom(value: boolean);
begin
  if (FZoom <> value) then  FZoom := value;
end;
procedure TCCDEditZoom.DoEnter;
begin
  FVColor:=Color;
  FVWidth:=Width;
  BringToFront;
  If FZoom= True then
  begin
      if MaxWidth = 0 then Width:=(Width * 3)
                      else Width:= MaxWidth;
      Height:=(Height * 3);
      Font.Size:=(Font.Size * 3);
  end;
  Color:=FEnterColor;
  if Assigned(FOnEnter) then FOnEnter(Self);
end;
procedure TCCDEditZoom.DoExit;
begin

  If FZoom= True then
  begin
      if MaxWidth = 0 then Width:=(Width div 3)
                      else Width:= FVWidth;
      Height:=(Height div 3);
      Font.Size:=(Font.Size div 3);
  end;
  Color:=FVColor;
  if Assigned(FOnExit) then FOnExit(Self);
end;

procedure TCCDEditZoom.CMMouseenter(var Message: TMessage);
begin
  Font.style := Font.Style + [fsBold];
end;

procedure TCCDEditZoom.CMMouseleave(var Message: TMessage);
begin
  inherited;
  Font.style := Font.Style - [fsBold];
end;

procedure TCCDEditZoom.SetMaxWidth(value: integer);
begin
  if (FMaxWidth <> value) then FMaxWidth := value;
end;

end.
