{ @abstract(Componente que permite editar texto agregando un
   botn del lado derecho.)
  @author(Hctor Carrillo Randolph (hectorrandolph@gmail.com))
  @created(Agosto 2004) }

unit UCCDEditButton;

interface

uses
  SysUtils, Classes, Windows, Messages, Controls, StdCtrls, Graphics,
  Buttons, UCCDTypes;

type
  {Componente TCCDEditButton derivado de TCustomEdit. }
  TCCDEditButton = class(TCustomEdit)
  private
     FAboutCCD: TAboutCCD;
     FBtnControl:TWinControl;
     FButton:TSpeedButton;
     FOnButtonClick: TNotifyEvent;
     FHideButton: Boolean;
     FAutoHideButton: Boolean;
     procedure BtnClick(Sender: TObject);
     function GetGlyph: TBitmap;
     function GetMinHeight: Integer;
     procedure SetEditRect;
     procedure SetGlyph(Value: TBitmap);
     procedure SetAutoHideButton(Value: Boolean);
     procedure SetHideButton(Value: Boolean);
     procedure CMFontChanged(var Message: TMessage); message CM_FONTCHANGED;
     procedure CMEnabledChanged(var Message: TMessage); message CM_ENABLEDCHANGED;
     procedure CMFocusChanged(var Message: TMessage);message  CM_FOCUSCHANGED;
     procedure WMSize(var Message: TWMSize); message WM_SIZE;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure KeyPress(var Key: Char);override;
    procedure KeyDown(var Key: Word; Shift: TShiftState);override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property AboutCCD: TAboutCCD read FAboutCCD stored false;

    property Anchors;
    property AutoSelect;
    {Permite ocultar autmaticamente el botn cuando
    el componente pierde el foco}
    property AutoHideButton: Boolean read FAutoHideButton write SetAutoHideButton
             default False;
    property CharCase;
    property Constraints;
    property Color;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property Glyph: TBitMap read GetGlyph write SetGlyph;
    {Cuando esta propiedad se pone en True el botn se oculta,
     cuando se pone en False el botn se muestra}
    property HideButton: Boolean read FHideButton write SetHideButton
             default False;
    property MaxLength;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopUpMenu;
    property ReadOnly;
    property ShowHint;
    property Text;
    property Visible;
    {Este evento ocurre cuando se pulsa sobre el botn}
    property OnButtonClick:TNotifyEvent read FOnButtonClick write FOnButtonClick;
    property OnChange;
    property OnContextPopup;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

{Procedimiento para registrar y agregar el componente a la paleta.}
procedure Register;

implementation

{$R TCCDEditButton.res}

constructor TCCDEditButton.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FBtnControl := TWinControl.Create(Self);
  FBtnControl.Width := 17;
  FBtnControl.Height := 17;
  FBtnControl.Visible := True;
  FBtnControl.Parent := Self;
  FButton:=TSpeedButton.Create(Self);
  FButton.SetBounds(0, 0, FBtnControl.Width, FBtnControl.Height);
  FButton.Visible:=True;
  FButton.Parent:=FBtnControl;
  FButton.OnClick:=BtnClick;
  FHideButton:=False;
  FAutoHideButton:=False;
  Glyph:=nil;
end;

destructor TCCDEditButton.Destroy;
begin
  FButton:=nil;
  inherited Destroy;
end;

procedure TCCDEditButton.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := Params.Style or ES_MULTILINE or WS_CLIPCHILDREN;
end;

procedure TCCDEditButton.CreateWnd;
begin
  inherited CreateWnd;
  SetEditRect;
end;

procedure TCCDEditButton.KeyDown(var Key: Word; Shift: TShiftState);
var
  M: TMsg;
begin
 if (Key=VK_RETURN) and (Shift=[ssCtrl]) then
 begin
   M.Message:=0;
   if PeekMessage(M, Handle, WM_CHAR, WM_CHAR, pm_Remove) and (M.Message = WM_QUIT) then
    PostQuitMessage(M.wparam);
   FButton.Click;
 end
 else
 if (Key=VK_DOWN) and (Shift=[ssAlt]) then
   FButton.Click
 else
   inherited KeyDown(Key,Shift);
end;

procedure TCCDEditButton.KeyPress(var Key: Char);
begin
  inherited KeyPress(Key);
  if Key=Char(VK_RETURN) then
   Key:=#0;
end;


procedure TCCDEditButton.CMFontChanged(var Message: TMessage);
begin
  inherited;
  GetMinHeight;
end;

procedure TCCDEditButton.CMEnabledChanged(var Message: TMessage);
begin
  inherited;
  FButton.Enabled:=Enabled;
end;

procedure TCCDEditButton.CMFocusChanged(var Message: TMessage);
begin
  if FAutoHideButton and (not FHideButton)then
  begin
    FBtnControl.Visible:=Focused;
    SetEditRect;
  end;
  inherited;
end;

procedure TCCDEditButton.WMSize(var Message: TWMSize);
var
  MinHeight: Integer;
begin
  inherited;
  MinHeight := GetMinHeight;
  if Height <> MinHeight then
  Height := MinHeight
  else begin
    if NewStyleControls then
      FBtnControl.SetBounds(ClientWidth - FButton.Width, 0, FButton.Width, ClientHeight)
    else
      FBtnControl.SetBounds(ClientWidth - FButton.Width, 1, FButton.Width, ClientHeight - 1);
    FButton.Height := FBtnControl.Height;
    SetEditRect;
  end;
end;


function TCCDEditButton.GetMinHeight: Integer;
var
  DC: HDC;
  SaveFont: HFont;
  SysMetrics, Metrics: TTextMetric;
  I,TextMargin: Integer;
begin
  DC := GetDC(0);
  GetTextMetrics(DC, SysMetrics);
  SaveFont := SelectObject(DC, Font.Handle);
  GetTextMetrics(DC, Metrics);
  SelectObject(DC, SaveFont);
  ReleaseDC(0, DC);
  I := SysMetrics.tmHeight;
  if I > Metrics.tmHeight then I := Metrics.tmHeight;
  TextMargin := I div 4;
  Result:=Metrics.tmHeight + TextMargin + GetSystemMetrics(SM_CYBORDER) * 4 + 1;
end;


procedure TCCDEditButton.SetEditRect;
var
  Loc: TRect;
begin
  Loc.Bottom := ClientHeight + 1;  {+1 is workaround for windows paint bug}
  if FBtnControl.Visible then
    Loc.Right:= FBtnControl.Left+1
  else
    Loc.Right:=ClientWidth+1;
  Loc.Top := 0;
  Loc.Left := 0;
  SendMessage(Handle, EM_SETRECT, 0, LongInt(@Loc));
end;

function TCCDEditButton.GetGlyph: TBitmap;
begin
  Result := FButton.Glyph;
end;

procedure TCCDEditButton.SetGlyph(Value: TBitmap);
begin
  if Value <> nil then
    FButton.Glyph := Value
  else
  begin
    FButton.Glyph.Handle := LoadBitmap(HInstance, 'ELLIPSIS');
    FButton.NumGlyphs := 1;
    FButton.Invalidate;
  end;
end;

procedure TCCDEditButton.SetAutoHideButton(Value: Boolean);
begin
  if Value<>FAutoHideButton then
  begin
    FAutoHideButton:=Value;
    if FAutoHideButton then
      FBtnControl.Visible:=(not FHideButton) and Focused
    else
      FBtnControl.Visible:=(not FHideButton); 
  end;
end;


procedure TCCDEditButton.SetHideButton(Value: Boolean);
begin
  if Value<>FHideButton then
  begin
    FHideButton:=Value;
    FBtnControl.Visible:=not (FHideButton or FAutoHideButton);
  end;
end;


procedure TCCDEditButton.BtnClick(Sender: TObject);
begin
  if not Focused then SetFocus;
  if Assigned(FOnButtonClick) then
     FOnButtonClick(Self);
end;

procedure Register;
begin
  RegisterComponents('ClubDelphi', [TCCDEditButton]);
end;

end.
