unit UCCDDbEditZoom;

interface

uses
   Windows, ExtCtrls, SysUtils, Controls,
   Messages, Classes, StdCtrls, Graphics,
   DBCtrls, UCCDTypes;

type
  TCCDDbEditZoom = class(TDBEdit)
  private
    { Private declarations }
    FAboutCCD: TAboutCCD;

    FZoom: Boolean;
    FVColor: TColor;
    FVWidth: Integer;
    FMaxWidth: Integer;
    FEnterColor: Tcolor;
    FOnExit: TNotifyEvent;
    FOnEnter: TNotifyEvent;

  protected
  { Protected declarations }
    procedure CMMouseenter(var Message: TMessage); message CM_MOUSEENTER;
    procedure CMMouseleave(var Message: TMessage); message CM_MOUSELEAVE;

  public
    { Public declarations }
    constructor Create(aOwner: TComponent); override;
    destructor Destroy(); override;
    procedure DoEnter; override;
    procedure DoExit; override;
    procedure SetZoom(value: boolean);
    procedure SetEnterColor(value: TColor);
    procedure SetMaxWidth(value: integer);
  published
    { Published declarations }
    property AboutCCD: TAboutCCD read FAboutCCD stored false;
    property OnEnter: TNotifyEvent read FOnEnter write FOnEnter;
    property OnExit: TNotifyEvent read FOnExit write FOnExit;
    property Zoom: boolean read FZoom write SetZoom default True;
    property EnterColor: TColor read FEnterColor write SetEnterColor default claqua;
    property MaxWidth: integer read FMaxWidth write SetMaxWidth default 0;
  end;

implementation

constructor TCCDDbEditZoom.Create(aOwner: TComponent);
begin
    inherited Create(aOwner);
    FEnterColor:= ClAqua;
    FZoom:= True;
    FVColor:= Color;
    FVWidth:=Width;
    FMaxWidth:=0;
end;

destructor TCCDDbEditZoom.Destroy();
begin
  inherited Destroy();
end;

procedure TCCDDbEditZoom.SetEnterColor(value : TColor);
begin
  if (FEnterColor <> value) then FEnterColor:= value;
end;

procedure TCCDDbEditZoom.SetZoom(value: boolean);
begin
  if (FZoom <> value) then  FZoom := value;
end;
procedure TCCDDbEditZoom.DoEnter;
begin
  FVColor:=Color;
  FVWidth:=Width;
  BringToFront;
  If FZoom= True then
  begin
      if MaxWidth = 0 then Width:=(Width * 3)
                      else Width:= MaxWidth;
      Height:=(Height * 3);
      Font.Size:=(Font.Size * 3);
  end;
  Color:=FEnterColor;
  if Assigned(FOnEnter) then FOnEnter(Self);
end;
procedure TCCDDbEditZoom.DoExit;
begin

  If FZoom= True then
  begin
      if MaxWidth = 0 then Width:=(Width div 3)
                      else Width:= FVWidth;
      Height:=(Height div 3);
      Font.Size:=(Font.Size div 3);
  end;
  Color:=FVColor;
  if Assigned(FOnExit) then FOnExit(Self);
end;

procedure TCCDDbEditZoom.CMMouseenter(var Message: TMessage);
begin
  Font.style := Font.Style + [fsBold];
end;

procedure TCCDDbEditZoom.CMMouseleave(var Message: TMessage);
begin
  inherited;
  Font.style := Font.Style - [fsBold];
end;

procedure TCCDDbEditZoom.SetMaxWidth(value: integer);
begin
  if (FMaxWidth <> value) then FMaxWidth := value;
end;

end.
