{******************************************************************************}
{  DBBoolLabel 1.0                                                        }
{  Autor:  Luis Bataller - Club Delphi                              }
{  Pgina de descargas: http://www.clubdelphi.com/componentes/                 }
{  Pas de orgen: Espaa, agosto de 2007.                                 }
{                                                                              }
{  TCCDDBBoolLabel                                                           }
{                                                                              }
{  Componente de acceso a base de datos que muestra un texto segn un campo    }
{  lgico.                                                                      }
{                                                                              }
{******************************************************************************}
unit UCCDDBBoolLabel;

interface

uses
  SysUtils, Classes, Controls, DB, ExtCtrls;

type
  TCCDDBBoolLabelDataLink = class;
  TCCDDBBoolLabel = class(TPanel)
  private
    { Private declarations }
    FDataLink : TCCDDBBoolLabelDataLink;
    FCaptionUnchecked: TCaption;
    FCaptionChecked: TCaption;
    FValueChecked: Variant;
    FValueUnchecked: Variant;
    FDataField: String;
    FDataSource: TDataSource;
    procedure SetCaptionChecked(const Value: TCaption);
    procedure SetCaptionUnchecked(const Value: TCaption);
    procedure SetValueChecked(const Value: Variant);
    procedure SetValueUnchecked(const Value: Variant);
    procedure SetDataField(const Value: String);
    procedure SetDataSource(const Value: TDataSource);
  protected
    { Protected declarations }
    procedure DataChanged;
    procedure EditingChanged;
    procedure ActiveChanged;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    // Valor para verdadero
    property ValueChecked : Variant read FValueChecked write SetValueChecked;
    // Valor para falso
    property ValueUnchecked : Variant read FValueUnchecked write SetValueUnchecked;
    // Etiqueta verdadero
    property CaptionChecked : TCaption read FCaptionChecked write SetCaptionChecked;
    // Etiqueta Falso
    property CaptionUnchecked : TCaption read FCaptionUnchecked write SetCaptionUnchecked;
    property DataSource : TDataSource read FDataSource write SetDataSource;
    property DataField : String read FDataField write SetDataField;
  end;

TCCDDBBoolLabelDataLink = class(TDataLink)
  private
    FLabel: TCCDDBBoolLabel;
  protected
    procedure EditingChanged; override;
    procedure DataSetChanged; override;
    procedure ActiveChanged; override;
  public
    constructor Create(lbl: TCCDDBBoolLabel);
    destructor Destroy; override;
  end;


implementation

{ TLabelDataLink }

procedure TCCDDBBoolLabelDataLink.ActiveChanged;
begin
  if FLabel <> nil then FLabel.ActiveChanged;

end;

constructor TCCDDBBoolLabelDataLink.Create(lbl: TCCDDBBoolLabel);
begin
  inherited Create;
  FLabel := lbl;
end;

procedure TCCDDBBoolLabelDataLink.DataSetChanged;
begin
  if FLabel <> nil then FLabel.DataChanged;
end;

destructor TCCDDBBoolLabelDataLink.Destroy;
begin
  FLabel := nil;
  inherited Destroy;
end;

procedure TCCDDBBoolLabelDataLink.EditingChanged;
begin
  if FLabel <> nil then FLabel.EditingChanged;
end;

{ TCCDDBBoolLabel }

procedure TCCDDBBoolLabel.ActiveChanged;
begin
  DataChanged;
end;

constructor TCCDDBBoolLabel.Create(AOwner: TComponent);
begin
  inherited;
  FValueChecked := 'True';
  FValueUnChecked := 'False';
  FCaptionChecked := 'True';
  FCaptionUnChecked := 'False';
  Enabled := True;
  BevelOuter := bvNone;
  FDataLink := TCCDDBBoolLabelDataLink.Create(Self);

end;

procedure TCCDDBBoolLabel.DataChanged;
begin
  if Assigned(DataSource) and Assigned(DataSource.DataSet) and
     DataSource.DataSet.Active then
  begin
    if DataSource.DataSet.FieldByName(DataField).AsVariant = ValueChecked then
      Caption := CaptionChecked
    else if DataSource.DataSet.FieldByName(DataField).AsVariant = ValueUnchecked then
      Caption := CaptionUnchecked;
  end;
end;

destructor TCCDDBBoolLabel.Destroy;
begin
  FDataLink.Free;
  inherited;
end;

procedure TCCDDBBoolLabel.EditingChanged;
begin
  DataChanged;
end;

procedure TCCDDBBoolLabel.SetCaptionChecked(const Value: TCaption);
begin
  FCaptionChecked := Value;
end;

procedure TCCDDBBoolLabel.SetCaptionUnchecked(const Value: TCaption);
begin
  FCaptionUnchecked := Value;
end;

procedure TCCDDBBoolLabel.SetDataField(const Value: String);
begin
  FDataField := Value;
end;

procedure TCCDDBBoolLabel.SetDataSource(const Value: TDataSource);
begin
  FDataSource := Value;
  FDataLink.DataSource := Value;
  if not (csLoading in ComponentState) then
    ActiveChanged;
  if Value <> nil then Value.FreeNotification(self);
end;

procedure TCCDDBBoolLabel.SetValueChecked(const Value: Variant);
begin
  FValueChecked := Value;
end;

procedure TCCDDBBoolLabel.SetValueUnchecked(const Value: Variant);
begin
  FValueUnchecked := Value;
end;

end.
