unit UCCDChangeCD;

interface

uses
	Windows, Messages, Classes, UCCDBaseComp;

type
	TCdChangeEvent = procedure(sender: TObject; drive: Char) of object;

	TCCDChangeCD = class(TCCDBaseComp)
	private
		FActive: Boolean;
		FInternalWindow: HWnd;
		FOnCdRemoved: TCdChangeEvent;
		FOnCdInserted: TCdChangeEvent;
  private
		procedure SetActive(value: Boolean);
		procedure WndProc(var msg: TMessage); virtual;
    function GetDriveFromMask(mask: Cardinal): Char;
	public
		constructor Create(AOwner: TComponent); override;
	published
		property Active: Boolean read FActive write SetActive default false;
		property OnCdRemoved: TCdChangeEvent read FOnCdRemoved write FOnCdRemoved;
		property OnCdInserted: TCdChangeEvent read FOnCdInserted write FOnCdInserted;
	end;

implementation

const
	DBTF_MEDIA = $0001;
	DBT_DEVICEARRIVAL = $8000;
	DBT_DEVTYP_VOLUME = $00000002;
	DBT_DEVICEREMOVECOMPLETE = $8004;

type
	PDevBroadcastHeader = ^TDevBroadcastHeader;
	TDevBroadcastHeader = record
		Size: Cardinal;
		DeviceType: Cardinal;
		Reserved: Cardinal;
	end;

	PDevBroadcastVolume = ^TDevBroadcastVolume;
	TDevBroadcastVolume = record
		Size: Cardinal;
		DeviceType: Cardinal;
		Reserved: Cardinal;
		UnitMask: Cardinal;
		Flags: Word;
	end;

	TWMDeviceChange = packed record
		Msg: Cardinal;
		Event: LongInt;
		Header: PDevBroadcastVolume;
		Result: LongInt;
	end;

constructor TCCDChangeCD.Create(AOwner: TComponent);
begin
	inherited;
	FActive := false;
end;

procedure TCCDChangeCD.SetActive(value: Boolean);
begin
	if (FActive <> value) then begin
		FActive := value;
		if not (csDesigning in ComponentState) then begin
			if FActive then
        FInternalWindow := AllocateHWnd(WndProc)
      else
        DeallocateHWnd(FInternalWindow);
    end;
	end;
end;

procedure TCCDChangeCD.WndProc(var msg: TMessage);
var
	drive: Char;
begin
	if msg.msg = WM_DEVICECHANGE then
  begin
		with TWMDeviceChange(msg) do begin
			if ((Event = DBT_DEVICEARRIVAL) or (Event = DBT_DEVICEREMOVECOMPLETE))
       and (Header.DeviceType = DBT_DEVTYP_VOLUME) and
				(PDevBroadcastVolume(Header).Flags and DBTF_MEDIA <> 0)
			then
      begin
				drive := GetDriveFromMask(PDevBroadcastVolume(Header).UnitMask);
				case Event of
					DBT_DEVICEARRIVAL: begin
						if Assigned(FOnCdInserted) then FOnCdInserted(Self, drive);
          end;
					DBT_DEVICEREMOVECOMPLETE: begin
						if Assigned(FOnCdRemoved) then FOnCdRemoved(Self, drive);
          end;
				end;
			end;
    end;
  end;
end;

function TCCDChangeCD.GetDriveFromMask(mask: Cardinal): Char;
var
	I: Byte;
const
	MAX_DRIVES = 26;
begin
	for I := 1 to MAX_DRIVES do begin
		if (mask and $01 <> 0) then break;
		mask := mask shr 1;
	end;
	Result := Chr(Ord('A') + I);
end;

end.