unit UCCDAboutProp;

interface

uses
  DesignIntf, DesignEditors;

type
  TCCDAboutProp = class(TPropertyEditor)
  public
    procedure Edit(); override;
    function GetValue(): string; override;
    function GetAttributes(): TPropertyAttributes; override;
  end;

implementation

uses
  SysUtils, UCCDResources, UCCDfrmAbout;

procedure TCCDAboutProp.Edit();
begin
  with TCCDfrmAbout.Create(nil) do
  try
    ShowModal();
  finally
    Free();
  end;
end;

function TCCDAboutProp.GetValue(): string;
begin
  result := Format(rsCCDAboutPropFormat,[rsCCDVersion]);
end;

function TCCDAboutProp.GetAttributes(): TPropertyAttributes;
begin
  result := [paDialog,paReadOnly];
end;

end.
