unit UDemo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DBXpress, FMTBcd, SqlExpr, DB, Provider, DBClient,
  UCCDDBImageGrid, ExtCtrls, UCCDDBBoolLabel, DBTables, StdCtrls, Grids,
  DBGrids, ComCtrls, Buttons, UCCDDBNavigator, ImgList;

type
  TForm1 = class(TForm)
    CCDDBBoolLabel1: TCCDDBBoolLabel;
    DataSource1: TDataSource;
    Table1: TTable;
    Button1: TButton;
    Button2: TButton;
    ImageGrid: TCCDDBImageGrid;
    Label1: TLabel;
    Label2: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    RadioGroup1: TRadioGroup;
    TrackBar1: TTrackBar;
    Label3: TLabel;
    RadioGroup2: TRadioGroup;
    TrackBar2: TTrackBar;
    TrackBar3: TTrackBar;
    Label4: TLabel;
    Label5: TLabel;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Panel1: TPanel;
    Image1: TImage;
    Panel2: TPanel;
    Image2: TImage;
    DBGrid1: TDBGrid;
    CCDDBNavigator1: TCCDDBNavigator;
    Label6: TLabel;
    ILNavigator: TImageList;
    ILNavigatorDisabled: TImageList;
    Table1SpeciesNo: TFloatField;
    Table1Category: TStringField;
    Table1Common_Name: TStringField;
    Table1SpeciesName: TStringField;
    Table1Lengthcm: TFloatField;
    Table1Length_In: TFloatField;
    Table1Notes: TMemoField;
    Table1Graphic: TGraphicField;
    Table1Orden: TIntegerField;
    Table1Marino: TBooleanField;
    Table1Color: TIntegerField;
    Table2: TTable;
    FloatField1: TFloatField;
    StringField1: TStringField;
    StringField2: TStringField;
    StringField3: TStringField;
    FloatField2: TFloatField;
    FloatField3: TFloatField;
    MemoField1: TMemoField;
    GraphicField1: TGraphicField;
    IntegerField1: TIntegerField;
    BooleanField1: TBooleanField;
    IntegerField2: TIntegerField;
    DataSource2: TDataSource;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure TrackBar3Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CCDDBNavigator1ClickSearch(Sender: TObject);
    procedure CCDDBNavigator1ClickAuto(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Unit2;

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  ImageGrid.PrevPage;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ImageGrid.NextPage;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  ImageGrid.AllowChangeOrder := CheckBox1.Checked;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  if CheckBox2.Checked then
    ImageGrid.ColorField := 'Color'
  else
    ImageGrid.ColorField := '';
end;

procedure TForm1.RadioGroup1Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
    0: ImageGrid.DisplayMode := bgStretch;
    1: ImageGrid.DisplayMode := bgZoom;
  end;
end;

procedure TForm1.TrackBar1Change(Sender: TObject);
begin
  ImageGrid.PosNavigator := TbgPosNavigator(TrackBar1.Position);
end;

procedure TForm1.RadioGroup2Click(Sender: TObject);
begin
  ImageGrid.Orientation := TBgOrientation(RadioGroup2.ItemIndex);
end;

procedure TForm1.TrackBar3Change(Sender: TObject);
begin
  ImageGrid.RowCount := TrackBar3.Position;
end;

procedure TForm1.TrackBar2Change(Sender: TObject);
begin
  ImageGrid.ColCount := TrackBar2.Position;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  BitBtn1.Visible := False;
  BitBtn2.Visible := False;
  Panel1.Visible := False;
  Panel2.Visible := False;
  Button1.Visible := True;
  Button2.Visible := True;
  ImageGrid.PrevPageControl := Button1;
  ImageGrid.NextPageControl := Button2;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  BitBtn1.Visible := True;
  BitBtn2.Visible := True;
  Panel1.Visible := False;
  Panel2.Visible := False;
  Button1.Visible := False;
  Button2.Visible := False;
  ImageGrid.PrevPageControl := BitBtn1;
  ImageGrid.NextPageControl := BitBtn2;

end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  BitBtn1.Visible := False;
  BitBtn2.Visible := False;
  Panel1.Visible := True;
  Panel2.Visible := True;
  Button1.Visible := False;
  Button2.Visible := False;
  ImageGrid.PrevPageControl := Panel1;
  ImageGrid.NextPageControl := Panel2;

end;

procedure TForm1.FormShow(Sender: TObject);
begin
  Table1.DatabaseName := '.\';
  Table1.Active := True;
  Table2.DatabaseName := '.\';
  Table2.Active := True;
end;

procedure TForm1.CCDDBNavigator1ClickSearch(Sender: TObject);
begin
  Form2.ShowModal;
end;

procedure TForm1.CCDDBNavigator1ClickAuto(Sender: TObject);
var
  newRec : Integer;
begin
  Table2.Last;
  newRec := Table2.FieldByName('Species No').AsInteger + 1;
  Table2.Append;
  Table2.FieldByName('Species No').AsInteger := newRec;
end;

end.
