unit UfrmPrincipal;

interface

uses
  Forms, OleCtrls, SHDocVw,
  StdCtrls, Classes, Controls,
  UCCDWebBrowser, ActnList;

type
  TfrmPrincipal = class(TForm)
    accSaludo: TAction;
    accCerrar: TAction;
    acciones: TActionList;
    btnCargarCadena: TButton;
    btnCargarArchivo: TButton;
    CCDWebBrowser: TCCDWebBrowser;
    procedure accSaludoExecute(Sender: TObject);
    procedure accCerrarExecute(Sender: TObject);
    procedure btnCargarCadenaClick(Sender: TObject);
    procedure btnCargarArchivoClick(Sender: TObject);
  end;

var
  frmPrincipal: TfrmPrincipal;

implementation

uses
  SysUtils, Dialogs;

{$R *.dfm}

procedure TfrmPrincipal.accCerrarExecute(Sender: TObject);
begin
  Close();
end;

procedure TfrmPrincipal.accSaludoExecute(Sender: TObject);
begin
  ShowMessage('Hola mundo!');
end;

procedure TfrmPrincipal.btnCargarArchivoClick(Sender: TObject);
var
  html: string;
begin
  html := ExtractFilePath(ParamStr(0))+'ejemplo.html';
  if FileExists(html) then CCDWebBrowser.Navigate('file:///'+html);
end;

procedure TfrmPrincipal.btnCargarCadenaClick(Sender: TObject);
begin
  with CCDWebBrowser do begin
    WriteHtml(LinkPerAction(accSaludo)+' - '+LinkPerAction(accCerrar));
  end;
end;

end.
