unit UfrmPrincipal;

interface

uses
  Forms, Controls, StdCtrls, Classes, ComCtrls,
  ExtCtrls, UCCDHashes, UCCDBaseComp;

type
  TfrmPrincipal = class(TForm)
    edHash: TEdit;
    lbHash: TLabel;                  
    edCadena: TEdit;
    edArchivo: TEdit;
    lbCadena: TLabel;
    lbArchivo: TLabel;
    btnCerrar: TButton;
    btnAbortar: TButton;
    tsCadenas: TTabSheet;
    CCDHashes: TCCDHashes;
    tsArchivos: TTabSheet;
    pcHashes: TPageControl;
    btnDlgArchivo: TButton;
    rgTipoHash: TRadioGroup;
    bProgreso: TProgressBar;
    btnCalcularHash: TButton;
    procedure CCDHashesAbort(Sender: TObject);
    procedure btnCerrarClick(Sender: TObject);
    procedure btnAbortarClick(Sender: TObject);
    procedure CCDHashesWorkEnd(Sender: TObject);
    procedure btnDlgArchivoClick(Sender: TObject);
    procedure btnCalcularHashClick(Sender: TObject);
    procedure CCDHashesWork(sender: TObject; progress: Integer);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure CCDHashesWorkBegin(sender: TObject; maxProgress: Integer);
  end;

var
  frmPrincipal: TfrmPrincipal;

implementation

uses
  SysUtils, Dialogs, UCCDExceptions;

{$R *.dfm}

procedure TfrmPrincipal.btnCalcularHashClick(Sender: TObject);
begin
  edHash.Clear();
  btnAbortar.Enabled := true;
  btnCalcularHash.Enabled := false;
  try
    if (pcHashes.ActivePageIndex = 0) and (Trim(edCadena.Text) <> '') then
      edHash.Text := CCDHashes.CalcStringHash(edCadena.Text, THashAlgorithm(rgTipoHash.ItemIndex))
    else if (pcHashes.ActivePageIndex = 1) then begin
      try
        edHash.Text := CCDHashes.CalcFileHash(edArchivo.Text, THashAlgorithm(rgTipoHash.ItemIndex))
      except
        on E: ECCDNoFileException do begin
          ShowMessage(E.Message);
        end;
      end;
    end;
  finally
    btnAbortar.Enabled := false;
    btnCalcularHash.Enabled := true;
  end;
end;

procedure TfrmPrincipal.btnAbortarClick(Sender: TObject);
begin
  if CCDHashes.Working then
    CCDHashes.Abort()
  else
    ShowMessage('El componente est inactivo');
end;

procedure TfrmPrincipal.btnDlgArchivoClick(Sender: TObject);
begin
  with TOpenDialog.Create(nil) do
  try
    if Execute() then edArchivo.Text := FileName;
  finally
    Free();
  end;
end;

procedure TfrmPrincipal.CCDHashesAbort(Sender: TObject);
begin
  bProgreso.Position := 0;
  ShowMessage('Tarea abortada');
end;

procedure TfrmPrincipal.CCDHashesWork(
 sender: TObject; progress: Integer);
begin
  Application.ProcessMessages();
  bProgreso.Position := progress;
end;

procedure TfrmPrincipal.CCDHashesWorkBegin(
 sender: TObject; maxProgress: Integer);
begin
  bProgreso.Max := maxProgress;
end;

procedure TfrmPrincipal.CCDHashesWorkEnd(Sender: TObject);
begin
  bProgreso.Position := 0;
  ShowMessage('Tarea terminada');
end;

procedure TfrmPrincipal.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  if CCDHashes.Working then
    CCDHashes.Abort();
  CanClose := true;
end;

procedure TfrmPrincipal.btnCerrarClick(Sender: TObject);
begin
  if CCDHashes.Working then
    CCDHashes.Abort();
  Close();
end;

end.
